<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Seen</title>

    <style>
      @charset "UTF-8";

      :root {
        --bs-font-sans-serif: system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", "Noto Sans", "Liberation Sans", Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";
        --bs-body-font-family: var(--bs-font-sans-serif);
        --bs-body-font-size: 1rem;
        --bs-body-font-weight: 400;
        --bs-body-line-height: 1.5;
        --bs-body-color: #212529;
        --bs-body-bg: #fff;
        --bs-link-color: #0d6efd;
        --bs-link-hover-color: #0a58ca;
        --bs-code-color: #d63384
      }

      *,
      ::after,
      ::before {
        box-sizing: border-box
      }

      @media (prefers-reduced-motion:no-preference) {
        :root {
          scroll-behavior: smooth
        }
      }

      body {
        margin: 0;
        font-family: var(--bs-body-font-family);
        font-size: var(--bs-body-font-size);
        font-weight: var(--bs-body-font-weight);
        line-height: var(--bs-body-line-height);
        color: var(--bs-body-color);
        text-align: var(--bs-body-text-align);
        background-color: var(--bs-body-bg);
        -webkit-text-size-adjust: 100%;
        -webkit-tap-highlight-color: transparent
      }

      .h1,
      .h2,
      .h3,
      h1,
      h2,
      h3 {
        margin-top: 0;
        margin-bottom: .5rem;
        font-weight: 500;
        line-height: 1.2
      }

      .h1,
      h1 {
        font-size: calc(1.375rem + 1.5vw)
      }

      @media (min-width:1200px) {

        .h1,
        h1 {
          font-size: 2.5rem
        }
      }

      .h2,
      h2 {
        font-size: calc(1.325rem + .9vw)
      }

      @media (min-width:1200px) {

        .h2,
        h2 {
          font-size: 2rem
        }
      }

      .h3,
      h3 {
        font-size: calc(1.3rem + .6vw)
      }

      @media (min-width:1200px) {

        .h3,
        h3 {
          font-size: 1.75rem
        }
      }

      p {
        margin-top: 0;
        margin-bottom: 1rem
      }

      address {
        margin-bottom: 1rem;
        font-style: normal;
        line-height: inherit
      }

      ul {
        padding-left: 2rem
      }

      ul {
        margin-top: 0;
        margin-bottom: 1rem
      }

      ul ul {
        margin-bottom: 0
      }

      strong {
        font-weight: bolder
      }

      sup {
        position: relative;
        font-size: .75em;
        line-height: 0;
        vertical-align: baseline
      }

      sup {
        top: -.5em
      }

      a {
        color: var(--bs-link-color);
        text-decoration: underline
      }

      a:hover {
        color: var(--bs-link-hover-color)
      }

      a:not([href]):not([class]),
      a:not([href]):not([class]):hover {
        color: inherit;
        text-decoration: none
      }

      code {
        font-family: var(--bs-font-monospace);
        font-size: 1em
      }

      code {
        font-size: .875em;
        color: var(--bs-code-color);
        word-wrap: break-word
      }

      a>code {
        color: inherit
      }

      img,
      svg {
        vertical-align: middle
      }

      caption {
        padding-top: .5rem;
        padding-bottom: .5rem;
        color: #6c757d;
        text-align: left
      }

      button {
        border-radius: 0
      }

      button:focus:not(:focus-visible) {
        outline: 0
      }

      button,
      input {
        margin: 0;
        font-family: inherit;
        font-size: inherit;
        line-height: inherit
      }

      button {
        text-transform: none
      }

      [type=button],
      [type=submit],
      button {
        -webkit-appearance: button
      }

      [type=button]:not(:disabled),
      [type=submit]:not(:disabled),
      button:not(:disabled) {
        cursor: pointer
      }

      ::-moz-focus-inner {
        padding: 0;
        border-style: none
      }

      ::-webkit-datetime-edit-day-field,
      ::-webkit-datetime-edit-fields-wrapper,
      ::-webkit-datetime-edit-hour-field,
      ::-webkit-datetime-edit-minute,
      ::-webkit-datetime-edit-month-field,
      ::-webkit-datetime-edit-text,
      ::-webkit-datetime-edit-year-field {
        padding: 0
      }

      ::-webkit-inner-spin-button {
        height: auto
      }

      [type=search] {
        outline-offset: -2px;
        -webkit-appearance: textfield
      }

      ::-webkit-search-decoration {
        -webkit-appearance: none
      }

      ::-webkit-color-swatch-wrapper {
        padding: 0
      }

      ::-webkit-file-upload-button {
        font: inherit;
        -webkit-appearance: button
      }

      ::file-selector-button {
        font: inherit;
        -webkit-appearance: button
      }

      [hidden] {
        display: none !important
      }

      .img-fluid {
        max-width: 100%;
        height: auto
      }

      .container,
      .container-fluid,
      .container-lg {
        --bs-gutter-x: 1.5rem;
        --bs-gutter-y: 0;
        width: 100%;
        padding-right: calc(var(--bs-gutter-x) * .5);
        padding-left: calc(var(--bs-gutter-x) * .5);
        margin-right: auto;
        margin-left: auto
      }

      @media (min-width:576px) {
        .container {
          max-width: 540px
        }
      }

      @media (min-width:768px) {
        .container {
          max-width: 720px
        }
      }

      @media (min-width:992px) {

        .container,
        .container-lg {
          max-width: 960px
        }
      }

      @media (min-width:1200px) {

        .container,
        .container-lg {
          max-width: 1140px
        }
      }

      @media (min-width:1400px) {

        .container,
        .container-lg {
          max-width: 1320px
        }
      }

      .row {
        --bs-gutter-x: 1.5rem;
        --bs-gutter-y: 0;
        display: flex;
        flex-wrap: wrap;
        margin-top: calc(-1 * var(--bs-gutter-y));
        margin-right: calc(-.5 * var(--bs-gutter-x));
        margin-left: calc(-.5 * var(--bs-gutter-x))
      }

      .row>* {
        flex-shrink: 0;
        width: 100%;
        max-width: 100%;
        padding-right: calc(var(--bs-gutter-x) * .5);
        padding-left: calc(var(--bs-gutter-x) * .5);
        margin-top: var(--bs-gutter-y)
      }

      .gx-1 {
        --bs-gutter-x: 0.25rem
      }

      .gy-4 {
        --bs-gutter-y: 1.5rem
      }

      @media (min-width:768px) {
        .col-md-12 {
          flex: 0 0 auto;
          width: 100%
        }
      }

      @media (min-width:992px) {
        .col-lg-4 {
          flex: 0 0 auto;
          width: 33.33333333%
        }

        .col-lg-6 {
          flex: 0 0 auto;
          width: 50%
        }
      }

      @media (min-width:1200px) {
        .col-xl-2 {
          flex: 0 0 auto;
          width: 16.66666667%
        }

        .col-xl-3 {
          flex: 0 0 auto;
          width: 25%
        }

        .col-xl-4 {
          flex: 0 0 auto;
          width: 33.33333333%
        }

        .col-xl-5 {
          flex: 0 0 auto;
          width: 41.66666667%
        }

        .col-xl-8 {
          flex: 0 0 auto;
          width: 66.66666667%
        }
      }

      @media (min-width:1400px) {
        .col-xxl-2 {
          flex: 0 0 auto;
          width: 16.66666667%
        }

        .col-xxl-6 {
          flex: 0 0 auto;
          width: 50%
        }
      }

      .nav {
        display: flex;
        flex-wrap: wrap;
        padding-left: 0;
        margin-bottom: 0;
        list-style: none
      }

      .navbar {
        --bs-navbar-padding-x: 0;
        --bs-navbar-padding-y: 0.5rem;
        position: relative;
        display: flex;
        flex-wrap: wrap;
        align-items: center;
        justify-content: space-between;
        padding: var(--bs-navbar-padding-y) var(--bs-navbar-padding-x)
      }

      .navbar>.container,
      .navbar>.container-fluid,
      .navbar>.container-lg {
        display: flex;
        flex-wrap: inherit;
        align-items: center;
        justify-content: space-between
      }

      .breadcrumb {
        --bs-breadcrumb-padding-x: 0;
        --bs-breadcrumb-padding-y: 0;
        --bs-breadcrumb-margin-bottom: 1rem;
        display: flex;
        flex-wrap: wrap;
        padding: var(--bs-breadcrumb-padding-y) var(--bs-breadcrumb-padding-x);
        margin-bottom: var(--bs-breadcrumb-margin-bottom);
        font-size: var(--bs-breadcrumb-font-size);
        list-style: none;
        background-color: var(--bs-breadcrumb-bg);
        border-radius: var(--bs-breadcrumb-border-radius)
      }

      @keyframes progress-bar-stripes {
        0% {
          background-position-x: 1rem
        }
      }

      @keyframes spinner-border {
        to {
          transform: rotate(360deg)
        }
      }

      @keyframes spinner-grow {
        0% {
          transform: scale(0)
        }

        50% {
          opacity: 1;
          transform: none
        }
      }

      .placeholder {
        display: inline-block;
        min-height: 1em;
        vertical-align: middle;
        cursor: wait;
        background-color: currentcolor;
        opacity: .5
      }

      @keyframes placeholder-glow {
        50% {
          opacity: .2
        }
      }

      @keyframes placeholder-wave {
        100% {
          -webkit-mask-position: -200% 0;
          mask-position: -200% 0
        }
      }

      .fixed-top {
        position: fixed;
        top: 0;
        right: 0;
        left: 0;
        z-index: 1030
      }

      .d-block {
        display: block !important
      }

      .d-flex {
        display: flex !important
      }

      .d-none {
        display: none !important
      }

      .position-relative {
        position: relative !important
      }

      .justify-content-center {
        justify-content: center !important
      }

      .align-items-center {
        align-items: center !important
      }

      .order-first {
        order: -1 !important
      }

      .order-last {
        order: 6 !important
      }

      .mt-3 {
        margin-top: 1rem !important
      }

      .mt-4 {
        margin-top: 1.5rem !important
      }

      .mt-5 {
        margin-top: 3rem !important
      }

      .me-auto {
        margin-right: auto !important
      }

      .mb-0 {
        margin-bottom: 0 !important
      }

      .mb-1 {
        margin-bottom: .25rem !important
      }

      .mb-3 {
        margin-bottom: 1rem !important
      }

      .pt-4 {
        padding-top: 1.5rem !important
      }

      .text-center {
        text-align: center !important
      }

      @media (min-width:992px) {
        .mt-lg-0 {
          margin-top: 0 !important
        }
      }

      @media (min-width:1200px) {
        .d-xl-block {
          display: block !important
        }

        .d-xl-none {
          display: none !important
        }
      }

      @font-face {
        font-family: Poppins;
        font-style: normal;
        font-weight: 400;
        font-display: swap;
        src: url(https://fonts.gstatic.com/s/poppins/v15/pxiEyp8kv8JHgFVrJJfecg.woff2) format("woff2");
        unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD
      }

      @font-face {
        font-family: Poppins;
        font-style: normal;
        font-weight: 500;
        font-display: swap;
        src: url(https://fonts.gstatic.com/s/poppins/v15/pxiByp8kv8JHgFVrLGT9Z1xlFQ.woff2) format("woff2");
        unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD
      }

      @font-face {
        font-family: Poppins;
        font-style: normal;
        font-weight: 600;
        font-display: swap;
        src: url(https://fonts.gstatic.com/s/poppins/v15/pxiByp8kv8JHgFVrLEj6Z1xlFQ.woff2) format("woff2");
        unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD
      }

      @font-face {
        font-family: Poppins;
        font-style: normal;
        font-weight: 700;
        font-display: swap;
        src: url(https://fonts.gstatic.com/s/poppins/v15/pxiByp8kv8JHgFVrLCz7Z1xlFQ.woff2) format("woff2");
        unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD
      }

      @font-face {
        font-family: Roboto;
        font-style: italic;
        font-weight: 400;
        font-display: swap;
        src: url(https://fonts.gstatic.com/s/roboto/v20/KFOkCnqEu92Fr1Mu51xIIzI.woff2) format("woff2");
        unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD
      }

      @font-face {
        font-family: Roboto;
        font-style: italic;
        font-weight: 500;
        font-display: swap;
        src: url(https://fonts.gstatic.com/s/roboto/v20/KFOjCnqEu92Fr1Mu51S7ACc6CsQ.woff2) format("woff2");
        unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD
      }

      @font-face {
        font-family: Roboto;
        font-style: italic;
        font-weight: 700;
        font-display: swap;
        src: url(https://fonts.gstatic.com/s/roboto/v20/KFOjCnqEu92Fr1Mu51TzBic6CsQ.woff2) format("woff2");
        unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD
      }

      @font-face {
        font-family: Roboto;
        font-style: normal;
        font-weight: 400;
        font-display: swap;
        src: url(https://fonts.gstatic.com/s/roboto/v20/KFOmCnqEu92Fr1Mu4mxK.woff2) format("woff2");
        unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD
      }

      @font-face {
        font-family: Roboto;
        font-style: normal;
        font-weight: 500;
        font-display: swap;
        src: url(https://fonts.gstatic.com/s/roboto/v20/KFOlCnqEu92Fr1MmEU9fBBc4.woff2) format("woff2");
        unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD
      }

      @font-face {
        font-family: Roboto;
        font-style: normal;
        font-weight: 700;
        font-display: swap;
        src: url(https://fonts.gstatic.com/s/roboto/v20/KFOlCnqEu92Fr1MmWUlfBBc4.woff2) format("woff2");
        unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD
      }

      body {
        background: #fff;
        color: #444;
        font-family: Roboto, sans-serif
      }

      a {
        color: #023b6d;
        transition: .3s;
        text-decoration: none
      }

      a:active,
      a:focus,
      a:hover {
        color: #009bd9;
        outline: 0;
        text-decoration: none
      }

      h1,
      h2,
      h3 {
        color: #023b6d;
        font-family: Poppins, sans-serif
      }

      .main {
        margin-top: 60px
      }

      .icon {
        width: 16px;
        height: 16px
      }

      .scroll-top {
        display: flex;
        justify-content: center;
        align-items: center;
        position: fixed;
        right: 15px;
        bottom: -15px;
        visibility: hidden;
        opacity: 0;
        width: 44px;
        height: 44px;
        background: #009bd9;
        border-radius: 4px;
        transition: .3s;
        z-index: 11
      }

      .scroll-top:hover {
        background: #03b7ff;
        box-shadow: 0 6px 15px 0 rgba(0, 155, 217, .3)
      }

      .scroll-top .icon {
        color: #fff;
        width: 20px;
        height: 20px
      }

      .scroll-top.active {
        visibility: visible;
        opacity: 1;
        transition: .3s;
        bottom: 15px
      }

      code {
        background: #e9e9e9;
        color: #444;
        border: 1px solid #ddd;
        border-radius: 2px;
        font-size: 12px;
        padding: 4px 8px 4px 8px
      }

      .header {
        background: #023b6d;
        height: 60px;
        z-index: 9999
      }

      .header .search-form {
        min-width: 240px
      }

      .header .search-form input {
        border: 1px solid rgba(255, 255, 255, .5);
        background-color: rgba(255, 255, 255, .05);
        color: #fff;
        border-radius: 0
      }

      .header .search-form input:focus {
        border-color: rgba(255, 255, 255, .8)
      }

      .header .search-form .icon {
        color: rgba(255, 255, 255, .8)
      }

      @media (min-width:1280px) {
        .navbar {
          padding: 0;
          position: static
        }

        .navbar ul {
          margin: 0;
          padding: 0;
          display: flex;
          list-style: none;
          align-items: center
        }

        .navbar>ul>li {
          white-space: nowrap;
          padding: 10px 0 10px 25px
        }

        .navbar a,
        .navbar a:focus {
          display: flex;
          align-items: center;
          justify-content: space-between;
          padding: 0 3px;
          font-size: 16px;
          font-weight: 400;
          color: rgba(255, 255, 255, .7);
          white-space: nowrap;
          transition: .3s;
          position: relative
        }

        .navbar a .icon,
        .navbar a:focus .icon {
          width: 20px;
          height: 20px;
          color: #009bd9
        }

        .navbar .active,
        .navbar .active:focus,
        .navbar a:hover,
        .navbar li:hover>a {
          color: #fff
        }

        .navbar .nav-categories ul {
          position: absolute;
          top: 60px;
          left: 12px;
          right: 12px;
          padding: 15px;
          height: auto;
          background: #fff;
          box-shadow: 0 5px 15px 0 rgba(2, 59, 109, .1);
          opacity: 0;
          visibility: hidden;
          transition: .2s;
          flex-wrap: wrap
        }

        .navbar .nav-categories ul li {
          display: flex;
          flex: 0 20%;
          align-items: center;
          padding: 8px 8px
        }

        .navbar .nav-categories ul a {
          padding: 0;
          color: #023b6d;
          margin-right: 5px;
          font-size: 15px;
          font-weight: 400
        }

        .navbar .nav-categories ul a:hover {
          color: #009bd9
        }

        .navbar .nav-categories ul a.active {
          font-weight: 700;
          color: #009bd9
        }

        .navbar .nav-categories ul .icon {
          color: #009bd9;
          width: 18px;
          height: 18px
        }

        .navbar .nav-categories ul span {
          color: #999;
          font-size: 13px;
          font-weight: 400
        }

        .navbar .nav-categories:hover>ul {
          opacity: 1;
          visibility: visible;
          transition: .2s
        }

        .navbar .memberarea .icon {
          margin: 2px 5px 0 0
        }

        .mobile-nav-hide,
        .mobile-nav-show {
          display: none
        }
      }

      @media (max-width:1279px) {
        .navbar {
          position: fixed;
          top: 60px;
          right: -100%;
          width: 100%;
          max-width: 400px;
          border-left: 1px solid #666;
          bottom: 0;
          transition: .3s;
          z-index: 9997
        }

        .navbar>ul {
          position: absolute;
          inset: 0;
          padding: 15px 0;
          margin: 0;
          background: rgba(255, 255, 255, .9);
          overflow-y: auto;
          transition: .3s;
          z-index: 9998;
          list-style: none;
          display: flex;
          flex-direction: column
        }

        .navbar a,
        .navbar a:focus {
          display: flex;
          align-items: center;
          padding: 10px 20px;
          font-size: 18px;
          font-weight: 400;
          color: #023b6d;
          white-space: nowrap;
          transition: .3s
        }

        .navbar a .icon,
        .navbar a:focus .icon {
          width: 20px;
          height: 20px;
          color: #009bd9;
          margin-left: 4px
        }

        .navbar .active,
        .navbar .active:focus,
        .navbar a:hover,
        .navbar li:hover>a {
          color: #009bd9
        }

        .navbar .memberarea .icon {
          margin: 2px 6px 0 0
        }

        .navbar .nav-search-form {
          display: none
        }

        .navbar .nav-categories {
          position: relative
        }

        .navbar .nav-categories ul {
          padding: 0 15px 0 25px;
          background: #fff;
          transition: .2s;
          display: none
        }

        .navbar .nav-categories ul li {
          display: flex;
          align-items: center;
          padding: 8px
        }

        .navbar .nav-categories ul a {
          padding: 0;
          color: #023b6d;
          margin-right: 5px;
          font-size: 16px;
          font-weight: 400
        }

        .navbar .nav-categories ul a:hover {
          color: #009bd9
        }

        .navbar .nav-categories ul a.active {
          font-weight: 700;
          color: #009bd9
        }

        .navbar .nav-categories ul .icon {
          color: #009bd9;
          width: 18px;
          height: 18px
        }

        .navbar .nav-categories ul span {
          color: #999;
          font-size: 13px;
          font-weight: 400
        }

        .navbar .nav-categories .nav-categories-active {
          display: block
        }

        .mobile-nav-toggle {
          margin: -4px 15px 0 15px
        }

        .mobile-nav-toggle .icon {
          color: rgba(255, 255, 255, .7);
          transition: .5s;
          z-index: 9999;
          width: 24px;
          height: 24px
        }

        .mobile-nav-active {
          overflow: hidden
        }

        .mobile-nav-active .navbar {
          right: 0
        }

        .mobile-nav-active .navbar:before {
          content: "";
          position: fixed;
          inset: 60px 0 0 0;
          background: rgba(255, 255, 255, .8);
          z-index: 9996
        }
      }

      .single-template h1 {
        font-size: 24px;
        padding: 0;
        margin: 0;
        color: #023b6d;
        font-weight: 500;
        background: #fff;
        font-family: Poppins, sans-serif
      }

      .single-template picture img {
        border: 1px solid #e2ebf5
      }

      .single-buttons {
        padding: 20px 0;
        display: flex
      }

      .single-buttons a {
        padding: 12px 5px;
        font-size: 16px;
        border-radius: 3px;
        font-weight: 500;
        transition: .25s;
        background: #035195;
        color: #fff;
        margin: 0 0 20px 0;
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        margin: 0 0 0 10px
      }

      .single-buttons a .icon {
        width: 20px;
        height: 20px;
        margin-right: 4px
      }

      .single-buttons a:hover {
        background: #0364b8;
        box-shadow: 0 6px 15px 0 rgba(2, 59, 109, .25)
      }

      .single-buttons a.template-demo {
        background-color: #009bd9;
        margin: 0 10px 0 0
      }

      .single-buttons a.template-demo:hover {
        background: #00a6e8
      }

      .template-details ul {
        list-style: none;
        padding: 0;
        margin: 0;
        display: flex
      }

      .template-details li {
        display: flex;
        width: 100%;
        justify-content: space-between;
        align-items: center;
        padding: 12px 20px;
        border: 1px solid #e2ebf5;
        background: #f9fbfd;
        margin: 0 10px 0 0
      }

      .template-details li:last-child {
        margin: 0 0 0 10px
      }

      .template-details strong {
        color: #023b6d;
        font-size: 14px;
        font-weight: 500
      }

      .template-details span {
        font-size: 14px
      }

      .template-details a {
        color: #0364b8
      }

      @media (max-width:480px) {
        .template-details ul {
          flex-direction: column
        }

        .template-details li {
          margin: 0 0 15px 0
        }

        .template-details li:last-child {
          margin: 0
        }
      }

      .download-template {
        margin-top: 40px
      }

      .download-template .features-list {
        margin-top: 185px
      }

      .download-template .features-list ul {
        background: #f7f9fc;
        list-style: none;
        padding: 0
      }

      .download-template .features-list li {
        height: 44px;
        padding: 0 10px;
        font-size: 15px;
        border-top: 1px solid #eef3f9;
        display: flex;
        align-items: center;
        justify-content: space-between
      }

      .download-template .features-list li:nth-child(odd) {
        background: #fdfefe
      }

      .download-template .features-list .help {
        position: absolute;
        top: 20%;
        transform: translate(-55%, -100%);
        left: 100%;
        width: 200px;
        background: #024681;
        color: #fff;
        border-radius: 4px;
        padding: 10px 15px;
        visibility: hidden;
        opacity: 0;
        transition: .2s;
        font-size: 14px
      }

      .download-template .features-list .icon {
        width: 20px;
        height: 20px;
        color: rgba(2, 59, 109, .45);
        transition: .3s;
        cursor: help
      }

      .download-template .features-list .icon:hover {
        color: #009bd9
      }

      .download-template .features-list .icon:hover+.help {
        top: -10%;
        visibility: visible;
        opacity: 1
      }

      .download-template .licenses .title {
        padding: 15px;
        text-align: center;
        background: #eef3f9;
        border-radius: 4px 4px 0 0;
        border-bottom: 4px solid #fff;
        height: 80px;
        overflow: hidden
      }

      .download-template .licenses .title h2 {
        margin: 0 0 5px 0;
        padding: 0;
        font-size: 20px;
        font-weight: 400;
        color: #111
      }

      .download-template .licenses .title span {
        display: block;
        color: #555;
        font-size: 14px;
        font-style: italic
      }

      .download-template .licenses .price {
        text-align: center;
        padding: 15px;
        background: #f7f9fc;
        height: 105px;
        overflow: hidden
      }

      .download-template .licenses .price h3 {
        font-size: 36px;
        margin: 0;
        padding: 0;
        color: #023b6d;
        font-weight: 500
      }

      .download-template .licenses .price h3 sup {
        margin-right: -8px;
        font-size: 24px
      }

      .download-template .licenses .price h3.old-price {
        color: #999;
        position: relative;
        font-size: 28px;
        margin-right: 5px;
        font-weight: 400
      }

      .download-template .licenses .price h3.old-price sup {
        margin-right: -8px;
        font-size: 18px
      }

      .download-template .licenses .price h3.old-price:after {
        content: '';
        display: block;
        width: 100%;
        height: 60%;
        position: absolute;
        top: 0;
        left: -2px;
        border-bottom: 3px solid rgba(255, 40, 28, .45);
        transform: rotate(-15deg)
      }

      .download-template .licenses .price span {
        display: block;
        color: #888;
        font-size: 13px;
        font-style: italic;
        line-height: 16px
      }

      .download-template .licenses .features {
        background: #f7f9fc
      }

      .download-template .licenses .features ul {
        list-style: none;
        padding: 0;
        margin: 0;
        text-align: center
      }

      .download-template .licenses .features li {
        padding: 10px;
        font-size: 15px;
        border-top: 1px solid #eef3f9;
        font-weight: 600
      }

      @media (min-width:1200px) {
        .download-template .licenses .features li {
          height: 44px;
          font-weight: 400
        }

        .download-template .licenses .features li:nth-child(odd) {
          background: #fdfefe
        }
      }

      .download-template .licenses .features li .feature-title {
        padding: 5px 0;
        font-size: 14px;
        font-weight: 400
      }

      .download-template .licenses .features li .feature-title s {
        color: #999
      }

      .download-template .licenses .features .icon {
        width: 20px;
        height: 20px
      }

      .download-template .licenses .features .icon-check {
        color: #00c560
      }

      .download-template .licenses .features .icon-close {
        color: red
      }

      .download-template .licenses .action {
        padding: 10px;
        border-radius: 0 0 4px 4px;
        border-top: 4px solid #fff;
        text-align: center;
        background: #eef3f9
      }

      .download-template .licenses .action div {
        font-weight: 700;
        font-size: 16px;
        padding-bottom: 8px
      }

      .download-template .licenses .action a {
        display: flex;
        padding: 12px 0;
        font-size: 15px;
        border-radius: 3px;
        transition: .3s;
        color: #fff;
        margin: 10px;
        font-weight: 500;
        justify-content: center;
        align-items: center;
        background: #035195;
        line-height: 0
      }

      .download-template .licenses .action a .icon {
        width: 20px;
        height: 20px;
        margin-right: 6px
      }

      .download-template .licenses .action a:hover {
        color: #fff;
        background: #0364b8;
        box-shadow: 0 6px 15px 0 rgba(2, 59, 109, .25)
      }

      .download-template .licenses .action a.buy {
        background: #00c560
      }

      .download-template .licenses .action a.buy:hover {
        background: #00d96a;
        box-shadow: 0 6px 15px 0 rgba(0, 197, 96, .25)
      }

      @keyframes animate-spinner {
        0% {
          transform: rotate(0)
        }

        100% {
          transform: rotate(360deg)
        }
      }

      .deal {
        padding: 40px 0;
        margin-bottom: 20px;
        background-position: center;
        background-repeat: no-repeat;
        background-size: cover;
        color: #000
      }

      .deal p {
        font-size: 26px
      }

      .page-header {
        padding: 50px 0 20px 0;
        margin-bottom: 50px;
        background: #fff;
        position: relative
      }

      .page-header:after {
        content: '';
        position: absolute;
        display: block;
        width: 60px;
        height: 3px;
        background: #009bd9;
        border-right: 3px solid #fff;
        left: calc(50% - 30px);
        bottom: 0
      }

      .page-header .page-title {
        font-size: 32px;
        padding: 0;
        margin: 0;
        color: #023b6d;
        font-weight: 600;
        background: #fff;
        font-family: Roboto, sans-serif;
        text-align: center
      }

      .search-bar-toggle {
        color: rgba(255, 255, 255, .7);
        width: 24px;
        height: 24px;
        margin-right: 5px;
        cursor: pointer;
        transition: .3s;
        display: none
      }

      .search-bar-toggle:hover {
        color: #fff
      }

      @media (max-width:1279px) {
        .search-bar-toggle {
          display: block
        }
      }

      .search-bar {
        position: fixed;
        top: 60px;
        left: 0;
        right: 0;
        padding: 20px 0;
        box-shadow: 0 0 15px 0 rgba(2, 59, 109, .1);
        background: #fff;
        z-index: 9999
      }

      .search-form input {
        border: 0;
        font-size: 14px;
        color: #023b6d;
        border: 1px solid rgba(2, 59, 109, .2);
        padding: 7px 38px 7px 10px;
        border-radius: 3px;
        transition: .3s;
        width: 100%
      }

      .search-form input:focus,
      .search-form input:hover {
        outline: 0;
        box-shadow: 0 0 10px 0 rgba(2, 59, 109, .15);
        border: 1px solid rgba(2, 59, 109, .3)
      }

      .search-form button {
        border: 0;
        padding: 0;
        margin-left: -30px;
        background: 0 0
      }

      .search-form button .icon {
        color: rgba(2, 59, 109, .6);
        width: 20px;
        height: 20px
      }

      .loading {
        display: none;
        background: #fff;
        text-align: center;
        padding: 15px;
        margin: 0 0 15px 0
      }

      .loading:before {
        content: "";
        display: inline-block;
        border-radius: 50%;
        width: 24px;
        height: 24px;
        border: 3px solid #18d26e;
        border-top-color: #eee;
        animation: animate-loading 1s linear infinite
      }

      @keyframes animate-loading {
        0% {
          transform: rotate(0)
        }

        100% {
          transform: rotate(360deg)
        }
      }

      .footer {
        margin-top: 30px
      }

      .footer-newsletter {
        background: #f4faff
      }

      .newsletter-form {
        padding: 50px 0;
        font-size: 16px;
        background: #f4faff;
        text-align: center
      }

      .newsletter-form h3 {
        font-size: 24px;
        margin: 0 0 20px 0;
        padding: 0;
        line-height: 1;
        font-weight: 600
      }

      .newsletter-form input[type=email] {
        border: 1px solid #fff;
        padding: 10px 12px;
        width: 100%;
        box-shadow: 0 2px 15px rgba(2, 59, 109, .12);
        display: block;
        transition: .3s
      }

      .newsletter-form input[type=email]:focus {
        outline: 0;
        border-color: #009bd9
      }

      .newsletter-form input[type=submit] {
        font-size: 16px;
        padding: 12px 40px;
        border: 0;
        background: #009bd9;
        color: #fff;
        transition: .3s;
        border-radius: 3px;
        box-shadow: 0 2px 15px rgba(2, 59, 109, .12)
      }

      .newsletter-form input[type=submit]:hover {
        background: #00a6e8;
        box-shadow: 0 0 30px rgba(2, 59, 109, .2)
      }

      .newsletter-form .error-message {
        display: none;
        color: #fff;
        background: #ed3c0d;
        text-align: center;
        padding: 15px;
        font-weight: 600;
        margin: 15px 0 0 0
      }

      .newsletter-form .sent-message {
        display: none;
        color: #fff;
        background: #18d26e;
        text-align: center;
        padding: 15px;
        font-weight: 600;
        margin: 15px 0 0 0
      }

      .footer-top {
        padding: 60px 0 30px 0;
        background: #023b6d;
        border-top: 2px solid #f4faff
      }

      .footer-top h3 {
        font-size: 16px;
        font-weight: 600;
        position: relative;
        padding-bottom: 12px;
        margin-bottom: 0;
        color: #fff
      }

      .footer-about {
        margin-bottom: 30px
      }

      .footer-about .description {
        font-size: 14px;
        line-height: 24px;
        margin: 10px 0 0 0;
        color: #fff
      }

      .social-links a {
        background: rgba(255, 255, 255, .2);
        color: #fff;
        margin-right: 5px;
        border-radius: 50px;
        text-align: center;
        width: 40px;
        height: 40px;
        transition: .3s;
        display: flex;
        justify-content: center;
        align-items: center;
        cursor: pointer
      }

      .social-links a:hover {
        background: #009bd9;
        color: #fff;
        text-decoration: none
      }

      .social-links .icon {
        width: 18px;
        height: 18px
      }

      .footer-nav {
        margin-bottom: 30px
      }

      .footer-nav ul {
        list-style: none;
        padding: 0;
        margin: 0
      }

      .footer-nav .icon {
        color: #009bd9;
        width: 18px;
        height: 18px;
        margin: 0 2px 0 -5px
      }

      .footer-nav li {
        padding: 6px 0;
        display: flex;
        align-items: center
      }

      .footer-nav li:first-child {
        padding-top: 0
      }

      .footer-nav a {
        transition: .3s;
        font-size: 15px;
        color: rgba(255, 255, 255, .7)
      }

      .footer-nav a:hover {
        text-decoration: none;
        color: #fff
      }

      .copyright {
        font-size: 15px;
        padding: 25px 0
      }

      .cookie-bar {
        background-color: rgba(0, 0, 0, .8);
        color: #fff;
        padding: 15px;
        position: fixed;
        left: 0;
        right: 0;
        bottom: 0;
        display: flex;
        justify-content: center;
        align-items: center;
        font-size: 14px;
        z-index: 99999999;
        transition: bottom 1s;
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol"
      }

      .cookie-bar a {
        color: #fff;
        text-decoration: underline
      }

      .cookie-bar .accept-cookies {
        background-color: #009bd9;
        color: #fff;
        border: 0;
        padding: 3px 15px;
        cursor: pointer;
        border-radius: 3px;
        transition: none;
        margin-left: 10px
      }

      .cookie-bar .accept-cookies:active,
      .cookie-bar .accept-cookies:hover {
        background-color: #0089c0
      }

      @media (max-width:1024px) {
        .cookie-bar {
          flex-direction: column
        }

        .cookie-bar span {
          padding-bottom: 10px
        }
      }
    </style>

  </head>
  <body>
    <header id="header" class="header fixed-top d-flex align-items-center">
      <div class="container-fluid container-lg d-flex align-items-center position-relative">
        <a href="#" rel="home" title="Bootstrap Templates | Premium & Free Download" class="me-auto">
          <h3 style="color: #f4faff;">Leads</h3>
        </a>
        <nav id="navbar" class="navbar">
          <ul>
            <li>
              <a href="#">Home</a>
            </li>
            <li class="nav-categories">
              <a href="#">
                <span>Templates</span>
                <svg class="icon icon-chevron-down" fill="currentColor">
                  <use xlink:href="#assets/img/icons.svg#chevron-down" />
                </svg>
              </a>
              <ul>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-business-templates/">Business</a>
                  <span>(62)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-education-templates/">Education</a>
                  <span>(1)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-admin-templates/">Admin</a>
                  <span>(1)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-coming-soon-templates/">Coming Soon</a>
                  <span>(3)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-one-page-templates/">One Page</a>
                  <span>(57)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-landing-page-templates/">Landing Page</a>
                  <span>(17)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-corporate-templates/">Corporate</a>
                  <span>(61)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-agency-templates/">Agency</a>
                  <span>(58)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-photography-website-templates/">Photography</a>
                  <span>(1)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-portfolio-templates/">Portfolio</a>
                  <span>(10)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-personal-templates/">Personal</a>
                  <span>(11)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-resume-cv-templates/">Resume / CV</a>
                  <span>(9)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-real-estate-templates/">Real Estate</a>
                  <span>(1)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-health-templates/">Health</a>
                  <span>(2)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-restaurant-templates/">Restaurant</a>
                  <span>(3)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-5-templates/">Bootstrap 5</a>
                  <span>(91)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-4-templates/">Bootstrap 4</a>
                  <span>(80)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#website-templates/">Website Templates</a>
                  <span>(33)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#free-website-templates/">Free Website Templates</a>
                  <span>(35)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-medical-templates/">Medical</a>
                  <span>(2)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-construction-website-templates/">Construction</a>
                  <span>(1)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-transportation-website-templates/">Transportation</a>
                  <span>(1)</span>
                </li>
                <li>
                  <svg class="icon icon-chevron-right" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#chevron-right" />
                  </svg>
                  <a href="#bootstrap-blog-magazine-templates/">Blog & Magazine</a>
                  <span>(1)</span>
                </li>
              </ul>
            </li>
            <li>
              <a href="#license/">License</a>
            </li>
            <li>
              <a href="#contact/">Contact</a>
            </li>
            <li>
              <a href="#members/" class="memberarea ">
                <svg class="icon icon-user2" fill="currentColor">
                  <use xlink:href="#assets/img/icons.svg#user2" />
                </svg>
                <span>Members</span>
              </a>
            </li>
            <li class="nav-search-form">
              <form class="search-form d-flex align-items-center ajaxform" data-append="#main" method="POST" action="#search/">
                <input type="text" value="" name="q" placeholder="Search" title="Enter search keyword">
                <button type="submit" title="Search">
                  <svg class="icon icon-search" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#search" />
                  </svg>
                </button>
              </form>
            </li>
          </ul>
        </nav>
        <svg class="icon icon-search search-bar-toggle" fill="currentColor">
          <use xlink:href="#assets/img/icons.svg#search" />
        </svg>
        <a href="#" class="mobile-nav-toggle mobile-nav-show" title="Toggle Menu">
          <svg class="icon icon-menu" fill="currentColor">
            <use xlink:href="#assets/img/icons.svg#menu" />
          </svg>
        </a>
        <a href="#" class="mobile-nav-toggle mobile-nav-hide d-none" title="Close Menu">
          <svg class="icon icon-close" fill="currentColor">
            <use xlink:href="#assets/img/icons.svg#close" />
          </svg>
        </a>
      </div>
    </header>
    <main id="main" class="main">

      <div class="container single-template">
        <div class="page-header">
          <h1 class="page-title"> Business Website Template</h1>
        </div>
        <div class="row gy-4">
          <div class="col-lg-6 order-last">
            <div class="single-contnet">
              <p>Nova is a modern multipurpose business bootstrap template. The template is highly suitable for any consulting agency, finance, consultant, advisor, business, and other agencies and businesses. Nova gives you the full ability to create modern business websites across various possible fields, industries, and businesses, and both personal and professional usages.</p>
              <p>Nova comes with a stunning homepage for small or large businesses, professional services & portfolios, blog, pricing, and other inner pages. Moreover, the Nova business template is mobile-friendly so that your website can be reached on different devices.</p>
              <p>Nova is a fully responsive template for mobile-friendly websites and applications. Every single feature and page element will look amazing on the screens of tablets and mobile phones. It includes page templates and layouts explicitly created to be the responsive visual environment on the market today.</p>
              <p>Nova would be an excellent choice for you to present your new business website based on a creative design.</p>
              <p>
                <strong>Here are some of the notable features:</strong>
              </p>
              <ul>
                <li>Fully responsive template</li>
                <li>Latest Bootstrap version</li>
                <li>No jQuery dependency</li>
                <li>Sass/SCSS source files included (pro and membership users only)</li>
                <li>Clean and modern design with clean code and easy to customize</li>
                <li>PHP/Ajax contact form script (pro version only.</li>
                <li>Animation on scroll effect</li>
                <li>Off-canvas mobile menu</li>
                <li>Filterable portfolio page</li>
                <li>Portfolio with lightbox support</li>
                <li>SEO Optimized</li>
                <li>Responsive video, object, embed</li>
                <li>Cross Browser compatible</li>
              </ul>
            </div>
          </div>
          
          <div class="col-lg-6 order-first">
            <a href="#demo/Nova/" target="_blank">
              <picture>
                <source type="image/webp" media="(min-width: 992px)" srcset="https://images.unsplash.com/photo-1585378335564-c220f04a9ad0?q=80&w=1974&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D">
                <source type="image/webp" media="(min-width: 480px) and (max-width: 991px)" srcset="https://images.unsplash.com/photo-1585378335564-c220f04a9ad0?q=80&w=1974&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D">
                <source type="image/webp" media="(max-width: 479px)" srcset="https://images.unsplash.com/photo-1585378335564-c220f04a9ad0?q=80&w=1974&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D">
                <img src="https://images.unsplash.com/photo-1585378335564-c220f04a9ad0?q=80&w=1974&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D" class="img-fluid" alt="Nova - Bootstrap Business Website Template" width="1320" height="990">
              </picture>
            </a>
            <div class="single-buttons">

            </div>
            <div class="template-details">
              <ul>
                <li>
                  <strong>Last Updated:</strong>
                  <span>Jan 29, 2024</span>
                </li>
                <li>
                  <strong>Built with:</strong>

                </li>
              </ul>
            </div>
          </div>
        </div>
        <div id="download-template" class="pt-4">
          <div class="row gx-1 download-template">
            <div class="col-xl-4 d-none d-xl-block features-list">
              <ul>
                <li>
                  <span>Use in personal projects</span>
                  <span class="position-relative d-block">
                    <svg class="icon icon-help" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#help" />
                    </svg>
                    <span class="help">Allows you to use the template to create personal websites for yourself</span>
                  </span>
                </li>
                <li>
                  <span>Number of websites/domains</span>
                  <span class="position-relative d-block">
                    <svg class="icon icon-help" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#help" />
                    </svg>
                    <span class="help">On how many domains/websites you can use the template(s)</span>
                  </span>
                </li>
                <li>
                  <span>Create websites for clients</span>
                  <span class="position-relative d-block">
                    <svg class="icon icon-help" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#help" />
                    </svg>
                    <span class="help">Allows you to use the template(s) to create websites for your clients and charge them as much as you want for your work</span>
                  </span>
                </li>
                <li>
                  <span>Remove footer credit link</span>
                  <span class="position-relative d-block">
                    <svg class="icon icon-help" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#help" />
                    </svg>
                    <span class="help">Allows you to remove the footer credit link and any other reference to BootstrapMade</span>
                  </span>
                </li>
                <li>
                  <span>Working <a href="#php-email-form/">
                      <strong>PHP/AJAX contact form</strong>
                    </a>
                  </span>
                  <span class="position-relative d-block">
                    <svg class="icon icon-help" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#help" />
                    </svg>
                    <span class="help">A working PHP/Ajax contact form script that allows you to receive messages submitted from the contact form to your Email inbox</span>
                  </span>
                </li>
                <li>
                  <span>Premium support via Email</span>
                  <span class="position-relative d-block">
                    <svg class="icon icon-help" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#help" />
                    </svg>
                    <span class="help">Premium support via Email</span>
                  </span>
                </li>
                <li>
                  <span>Sass/SCSS Files</span>
                  <span class="position-relative d-block">
                    <svg class="icon icon-help" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#help" />
                    </svg>
                    <span class="help">Access the Sass/SCSS source files</span>
                  </span>
                </li>
                <li>
                  <span>Access to all our <strong>91</strong> pro templates </span>
                  <span class="position-relative d-block">
                    <svg class="icon icon-help" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#help" />
                    </svg>
                    <span class="help">Access to all our currently avilable <strong>91</strong> pro templates + new templates released during your membership </span>
                  </span>
                </li>
              </ul>
            </div>
            <div class="col-xl-8 licenses">
              <div class="row gx-1">
                <div class="col-lg-4 mt-4 mt-lg-0 free">
                  <div class="title">
                    <h2>Nova Free</h2>
                    <span>Limited</span>
                  </div>
                  <div class="price">
                    <h3>
                      <sup>$</sup> 0
                    </h3>
                  </div>
                  <div class="features">
                    <ul>
                      <li>
                        <svg class="icon icon-check" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#check" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">Use in personal projects</span>
                      </li>
                      <li>1 <span class="d-block d-xl-none feature-title">Number of websites/domains</span>
                      </li>
                      <li>
                        <svg class="icon icon-close" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#close" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">
                          <s>Create websites for clients</s>
                        </span>
                      </li>
                      <li>
                        <svg class="icon icon-close" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#close" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">
                          <s>Remove footer credit link</s>
                        </span>
                      </li>
                      <li>
                        <svg class="icon icon-close" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#close" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">
                          <s>Working <a href="#php-email-form/">
                              <strong>PHP/AJAX contact form</strong>
                            </a>
                          </s>
                        </span>
                      </li>
                      <li>
                        <svg class="icon icon-close" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#close" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">
                          <s>Premium support via Email</s>
                        </span>
                      </li>
                      <li>
                        <svg class="icon icon-close" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#close" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">
                          <s>Sass/SCSS Files</s>
                        </span>
                      </li>
                      <li>
                        <svg class="icon icon-close" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#close" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">
                          <s>Access to all our <strong>91</strong> pro templates </s>
                        </span>
                      </li>
                    </ul>
                  </div>
                  <div class="action">
                    
                  </div>
                </div>
                <div class="col-lg-4 mt-5 mt-lg-0 pro">
                  <div class="title">
                    <h2>Nova Pro</h2>
                    <span>Extra Features</span>
                  </div>
                  <div class="price">
                    <div class="d-flex justify-content-center align-items-center">
                      <h3>
                        <sup>$</sup> 19
                      </h3>
                    </div>
                    <span>One time payment</span>
                    <span>Lifetime access</span>
                  </div>
                  <div class="features">
                    <ul>
                      <li>
                        <svg class="icon icon-check" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#check" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">Use in personal projects</span>
                      </li>
                      <li>1 <span class="d-block d-xl-none feature-title">Number of websites/domains</span>
                      </li>
                      <li>
                        <svg class="icon icon-check" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#check" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">Create websites for clients</span>
                      </li>
                      <li>
                        <svg class="icon icon-check" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#check" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">Remove footer credit link</span>
                      </li>
                      <li>
                        <svg class="icon icon-check" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#check" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">Working <a href="#php-email-form/">
                            <strong>PHP/AJAX contact form</strong>
                          </a>
                        </span>
                      </li>
                      <li>
                        <svg class="icon icon-check" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#check" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">Premium support via Email</span>
                      </li>
                      <li>
                        <svg class="icon icon-check" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#check" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">Sass/SCSS Files</span>
                      </li>
                      <li>
                        <svg class="icon icon-close" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#close" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">
                          <s>Access to all our <strong>91</strong> pro templates </s>
                        </span>
                      </li>
                    </ul>
                  </div>
                  <div class="action">
                
                  </div>
                </div>
                <div class="col-lg-4 mt-5 mt-lg-0 membership">
                  <div class="title">
                    <h2>Membership</h2>
                    <span>Get <strong>91</strong> templates </span>
                  </div>
                  <div class="price">
                    <div class="d-flex justify-content-center align-items-center">
                      <h3>
                        <sup>$</sup> 49
                      </h3>
                    </div>
                    <span>For 3 months access</span>
                    <span>No auto renewal</span>
                  </div>
                  <div class="features">
                    <ul>
                      <li>
                        <svg class="icon icon-check" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#check" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">Use in personal projects</span>
                      </li>
                      <li>Unlimited <span class="d-block d-xl-none feature-title">Number of websites/domains</span>
                      </li>
                      <li>
                        <svg class="icon icon-check" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#check" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">Create websites for clients</span>
                      </li>
                      <li>
                        <svg class="icon icon-check" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#check" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">Remove footer credit link</span>
                      </li>
                      <li>
                        <svg class="icon icon-check" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#check" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">Working <a href="#php-email-form/">
                            <strong>PHP/AJAX contact form</strong>
                          </a>
                        </span>
                      </li>
                      <li>
                        <svg class="icon icon-check" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#check" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">Premium support via Email</span>
                      </li>
                      <li>
                        <svg class="icon icon-check" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#check" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">Sass/SCSS Files</span>
                      </li>
                      <li>
                        <svg class="icon icon-check" fill="currentColor">
                          <use xlink:href="#assets/img/icons.svg#check" />
                        </svg>
                        <span class="d-block d-xl-none feature-title">Access to all our <strong>91</strong> pro templates </span>
                      </li>
                    </ul>
                  </div>
                  <div class="action">
               
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </main>
    
    <ins  id="app-<?php echo $_GET['key']; ?>"></ins>
        <script>(function() { /* DON'T EDIT  THIS LINE*/ var d = document, s = d.createElement('script'); s.src = 'https://widget.leads.fr/widgets/offer.js?key=<?php echo $_GET['key']; ?>'; (d.body).appendChild(s);})();</script><noscript>Please enable JavaScript to view the</noscript> 


    <footer id="footer" class="footer">
      <div class="footer-newsletter">
        <div class="container">
          <div class="row justify-content-center">
            <div class="col-lg-6">
              <div class="newsletter-form">
                <h3>Join Our Newsletter</h3>
                <p>Subscribe to our newsletter to receive emails about new template releases and updates</p>
                <form action="#newsletter/subscribe/" method="POST" class="php-email-form" id="newsletter-form">
                  <input type="hidden" name="source" value="form">
                  <input type="hidden" name="name" value="">
                  <input type="email" class="mb-3" name="email" title="Enter your Email address" placeholder="Enter your Email address" required>
                  <input type="submit" value="Subscribe" title="Subscribe">
                  <div class="loading mt-3"></div>
                  <div class="error-message"></div>
                  <div class="sent-message">Your subscription request has been sent. Please click on the confirmation link that we sent to your Email.</div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="footer-top">
        <div class="container">
          <div class="row">
            <div class="col-xxl-6 col-xl-5 col-md-12 footer-about">
              <a href="#" rel="home" title="Bootstrap Templates | Premium & Free Download" class="logo d-flex align-items-center">
                <img alt="BootstrapMade" src="#assets/img/logo.png" width="214" height="30">
              </a>
              <p class="description"> High quality free Bootstrap website templates. Build your next website with our modern and fully responsive web templates!</p>
              <div class="social-links d-flex mt-3">
                <a href="https://twitter.com/BootstrapMade" target="_blank" title="Follow us on Twitter" rel="nofollow external noopener noreferrer">
                  <svg class="icon icon-twitter" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#twitter" />
                  </svg>
                </a>
                <a href="https://facebook.com/BootstrapMade" target="_blank" title="Follow us on Facebook" rel="nofollow external noopener noreferrer">
                  <svg class="icon icon-facebook" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#facebook" />
                  </svg>
                </a>
                <a href="https://feeds.feedburner.com/BootstrapMade" target="_blank" title="Subscribe to our RSS feed" rel="nofollow external noopener noreferrer">
                  <svg class="icon icon-rss" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#rss" />
                  </svg>
                </a>
                <a href="#newsletter/" title="Subscribe to our newsletter">
                  <svg class="icon icon-mail" fill="currentColor">
                    <use xlink:href="#assets/img/icons.svg#mail" />
                  </svg>
                </a>
              </div>
            </div>
            <div class="col-xl-2 col-lg-4">
              <h3>Company</h3>
              <nav class="footer-nav">
                <ul>
                  <li>
                    <svg class="icon icon-chevron-right" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#chevron-right" />
                    </svg>
                    <a href="#about/">About</a>
                  </li>
                  <li>
                    <svg class="icon icon-chevron-right" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#chevron-right" />
                    </svg>
                    <a href="#license/">License</a>
                  </li>
                  <li>
                    <svg class="icon icon-chevron-right" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#chevron-right" />
                    </svg>
                    <a href="#php-email-form/">PHP Email Form</a>
                  </li>
                  <li>
                    <svg class="icon icon-chevron-right" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#chevron-right" />
                    </svg>
                    <a href="#terms/">Terms of service</a>
                  </li>
                  <li>
                    <svg class="icon icon-chevron-right" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#chevron-right" />
                    </svg>
                    <a href="#privacy/">Privacy policy</a>
                  </li>
                </ul>
              </nav>
            </div>
            <div class="col-xl-2 col-lg-4">
              <h3>Popular Templates</h3>
              <nav class="footer-nav">
                <ul>
                  <li>
                    <svg class="icon icon-chevron-right" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#chevron-right" />
                    </svg>
                    <a href="#arsha-free-bootstrap-html-template-corporate/">Arsha</a>
                  </li>
                  <li>
                    <svg class="icon icon-chevron-right" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#chevron-right" />
                    </svg>
                    <a href="#onepage-multipurpose-bootstrap-template/">OnePage</a>
                  </li>
                  <li>
                    <svg class="icon icon-chevron-right" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#chevron-right" />
                    </svg>
                    <a href="#mamba-one-page-bootstrap-template-free/">Mamba</a>
                  </li>
                  <li>
                    <svg class="icon icon-chevron-right" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#chevron-right" />
                    </svg>
                    <a href="#company-free-html-bootstrap-template/">Company</a>
                  </li>
                  <li>
                    <svg class="icon icon-chevron-right" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#chevron-right" />
                    </svg>
                    <a href="#free-html-bootstrap-template-my-resume/">MyResume</a>
                  </li>
                </ul>
              </nav>
            </div>
            <div class="col-xxl-2 col-xl-3 col-lg-4">
              <h3>Popular Categories</h3>
              <nav class="footer-nav">
                <ul>
                  <li>
                    <svg class="icon icon-chevron-right" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#chevron-right" />
                    </svg>
                    <a href="#bootstrap-5-templates/">Bootstrap 5 Templates</a>
                  </li>
                  <li>
                    <svg class="icon icon-chevron-right" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#chevron-right" />
                    </svg>
                    <a href="#website-templates/">Website Templates</a>
                  </li>
                  <li>
                    <svg class="icon icon-chevron-right" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#chevron-right" />
                    </svg>
                    <a href="#bootstrap-one-page-templates/">One Page Template</a>
                  </li>
                  <li>
                    <svg class="icon icon-chevron-right" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#chevron-right" />
                    </svg>
                    <a href="#bootstrap-portfolio-templates/">Portfolio Templates</a>
                  </li>
                  <li>
                    <svg class="icon icon-chevron-right" fill="currentColor">
                      <use xlink:href="#assets/img/icons.svg#chevron-right" />
                    </svg>
                    <a href="#free-website-templates/">Free Website Templates</a>
                  </li>
                </ul>
              </nav>
            </div>
          </div>
        </div>
      </div>
      <div class="container">
        <div class="copyright text-center"> Copyright &copy; 2024 <a href="#">BootstrapMade</a>
        </div>
      </div>
    </footer>
    <div title="Search" class="search-bar d-none">
      <div class="container">
        <div class="row justify-content-center">
          <div class="col-lg-6">
            <form class="search-form d-flex align-items-center ajaxform" data-append="#main" method="POST" action="#search/">
              <input type="text" value="" name="q" placeholder="Search" title="Enter search keyword">
              <button type="submit" title="Search">
                <svg class="icon icon-search" fill="currentColor">
                  <use xlink:href="#assets/img/icons.svg#search" />
                </svg>
              </button>
            </form>
          </div>
        </div>
      </div>
    </div>
    <a href="#" class="scroll-top" title="Back to top">
      <svg class="icon icon-arrow-up" fill="currentColor">
        <use xlink:href="#assets/img/icons.svg#arrow-up" />
      </svg>
    </a>
    <script src="#assets/js/main.js?v=5.2"></script>
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-P7JSYB1CSP"></script>
    <script>
      window.dataLayer = window.dataLayer || [];

      function gtag() {
        dataLayer.push(arguments);
      }
      gtag('js', new Date());
      gtag('config', 'G-P7JSYB1CSP');
    </script>
    <script defer src="https://static.cloudflareinsights.com/beacon.min.js/v84a3a4012de94ce1a686ba8c167c359c1696973893317" integrity="sha512-euoFGowhlaLqXsPWQ48qSkBSCFs3DPRyiwVu3FjR96cMPx+Fr+gpWRhIafcHwqwCqWS42RZhIudOvEI+Ckf6MA==" data-cf-beacon='{"rayId":"85c7e5772e154898","version":"2024.2.1","token":"68c5ca450bae485a842ff76066d69420"}' crossorigin="anonymous"></script>
  </body>
</html>